Attribute VB_Name = "mdCreateRevolution"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.



Function CreateRevolution(profileSketch As aSketch, axisSketch As aSketch, revolutionAngle As Double, revolutionDirection As Long, side As Long, materialStatus As Long, revolutionName As String, thin As Boolean)

'Convenience Function to Revolve a  profile in the specified sketch about an axis

'Get the ProDESKTOP Application Object
GetApplicationObject

'Get the Active Part Document
Dim Part As PartDocument
Set Part = app.GetActiveDoc

'Continue only if Part is available
If Part Is Nothing Then
   Set CreateRevolution = Nothing
   Exit Function
End If

'perform operation to create revolution
Dim revolution As aRevolution
Set revolution = app.GetClass("Revolution").CreateRevolution(Part.GetDesign, profileSketch, axisSketch, revolutionAngle, revolutionDirection, side, materialStatus, thin)

If Not revolution Is Nothing Then
    revolution.SetName revolutionName
    Part.UpdateDesign
End If

Set CreateRevolution = revolution

End Function



